#include <linux/bpf.h>
#include <linux/in.h>
#include <linux/in6.h>
#include <linux/version.h>

#include <bpf_helpers.h>

SEC("cgroup/setsockopt")
int tclass_lock(struct bpf_sockopt *ctx)
{
    if (ctx->level == IPPROTO_IPV6 && ctx->optname == IPV6_TCLASS) {
        ctx->optlen = -1;
    } else {
        ctx->optlen = 0;
    }
    return 1;
}

char _license[] SEC("license") = "GPL";
__u32 _version SEC("version") = LINUX_VERSION_CODE;
