#pragma once

#include <util/system/thread.h>
#include <util/system/event.h>

#include <infra/ebpf-agent/lib/pahom_client.h>

namespace NEbpfAgent {

    class TDaemon {
    public:
        TDaemon& ParseCmdline(int argc, char* argv[]);

        int Run();
        void Stop();

    private:
        friend TDaemon& Daemon() noexcept;
        TDaemon() noexcept;

        enum ECommand {
            NoCommand = 0,
            JugglerCheck,
            Cleanup,
            GetDatacenter,
        };
        ECommand Command = NoCommand;
        TVector<TString> CommandArgs;
        int RunCommand();

        static void* BpfWorkerLoopWrapper(void* param);
        void BpfWorkerLoop();

        static void* PahomUpdaterLoopWrapper(void* param);
        void TryReadYttlBlacklistNetsFromFile(const TString& path);
        void PahomUpdaterLoop();

        bool ForceRun = false;

        TThread BpfWorker;
        TThread PahomUpdater;

        TPahomClient PahomClient;

        TManualEvent Stopped;
    };

    TDaemon& Daemon() noexcept;

} // namespace NEbpfAgent
