#!/bin/bash

# default
TC=TC_CS4_ECN
RT_URL='https://ro.racktables.yandex-team.ru/export/macro-to-projectid.json'

if [ -z "$1" ]; then
    echo "usage $0 <macros> [traffic_class]"
    exit 1
fi

if [ -n "$2" ]; then
    TC=$2
fi

ids=$(curl $RT_URL -s | jq ".$1[]" | sed 's/"//g')

for id in $ids;
do
    id=$(printf '%8s' $id | sed 's/ /0/g')
    echo "{ HTONL(0x$id), $TC },"
done

exit 0
