BUILD_ONLY_IF(LINUX)

IF(NOT ENV_BASE_DIR)
   MESSAGE(FATAL_ERROR 'ENV_BASE_DIR' variable is not defined)
ENDIF()

IF(NOT ENV_VIRT_MODE)
   MESSAGE(FATAL_ERROR 'ENV_VIRT_MODE' variable is not defined)
ENDIF()

DEFAULT(ENV_BUILDER_ARCADIA_CHROOT_ARGS '')

INCLUDE(${ARCADIA_ROOT}/infra/qemu/env.inc)

DEFAULT(ENV_VMEXEC_VCPUS 1)
DEFAULT(ENV_VMEXEC_MEM 2G)
DEFAULT(ENV_VMEXEC_VOL_SECURITY 'none')
DEFAULT(ENV_ADDITIONAL_IN "")

# Default wrapper to launch in qemu vm by vmexec
IF(NOT ENV_BUILDER_WRAPPER_TOOL)
    # bootstrap rootfs image
    IF(NOT ENV_VMEXEC_ROOTFS)
        SET(ENV_VMEXEC_ROOTFS infra/environments/qavm/release/vm-image)
    ENDIF()

    IF(NOT ENV_VMEXEC_ROOTFS_NAME)
        SET(ENV_VMEXEC_ROOTFS_NAME rootfs.img)
    ENDIF()

    SET(ENV_BUILDER_WRAPPER_TOOL infra/qemu/vmexec)

    # Pass debug into vmexec
    IF(NOT ENV_BUILDER_WRAPPER_DEBUG_ARG)
       IF(ENV_BUILDER_DEBUG)
          SET(ENV_BUILDER_WRAPPER_DEBUG_ARG --debug)
       ELSE()
          SET(ENV_BUILDER_WRAPPER_DEBUG_ARG --verbose)
       ENDIF()
    ENDIF()

    SET(ENV_BUILDER_WRAPPER_ARGS
        ${ENV_BUILDER_WRAPPER_DEBUG_ARG}
        --qemu-bin ${QEMU_BIN_APP}
        --rootfs ${ENV_VMEXEC_ROOTFS}/${ENV_VMEXEC_ROOTFS_NAME}
        --vcpus ${ENV_VMEXEC_VCPUS}
	--mem ${ENV_VMEXEC_MEM}
	--volume-security ${ENV_VMEXEC_VOL_SECURITY}
        --arcadia-source ${ARCADIA_ROOT}
        --arcadia-build ${ARCADIA_BUILD_ROOT} -- )

    SET(ENV_BUILDER_WRAPPER_PEERDIR
        ${QEMU_BIN_ROOT}
        ${ENV_BUILDER_WRAPPER_TOOL}
        ${ENV_VMEXEC_ROOTFS}
    )

    SET(ENV_BUILDER_WRAPPER_IN
        ${QEMU_BIN_APP}
        ${ENV_VMEXEC_ROOTFS}/${ENV_VMEXEC_ROOTFS_NAME}
	${ENV_ADDITIONAL_IN}
    )
ENDIF()

# Default builder tool
IF(NOT ENV_BUILDER_TOOL)
    SET(ENV_BUILDER_TOOL infra/environments/builder)
    SET(ENV_BUILDER_PEERDIR ${ENV_BUILDER_TOOL})
ENDIF()

IF (NOT ENV_BUILD_LOG)
   SET(ENV_BUILD_LOG build.log)
ENDIF()

IF (NOT ENV_SCRIPT_DIR)
    SET(ENV_SCRIPT_DIR ${ENV_BASE_DIR}/script)
ENDIF()

IF (ENV_FLAVOR)
   SET(ENV_FLAVOR_SUFFIX -${ENV_FLAVOR})
ENDIF()

IF (NOT ENV_LAYER_DIR)
   SET(ENV_LAYER_DIR ${ENV_BASE_DIR}/${ENV_RELEASE}${ENV_VIRT_MODE}-layer${ENV_FLAVOR_SUFFIX})
ENDIF()

IF (NOT ENV_LAYER_NAME)
   SET(ENV_LAYER_NAME layer.tar.gz)
ENDIF()

IF (NOT ENV_LAYER_COMPRESS)
   SET(ENV_LAYER_COMPRESS auto)
ENDIF()

IF (NOT ENV_BASE_LAYER_NAME)
   SET(ENV_BASE_LAYER_NAME layer.tar.gz)
ENDIF()

IF (NOT ENV_IMAGE_LAYER)
   SET(ENV_IMAGE_LAYER ${ENV_VIRT_MODE}-layer${ENV_FLAVOR_SUFFIX})
ENDIF()

IF (NOT ENV_IMAGE_LAYER_NAME)
   SET(ENV_IMAGE_LAYER_NAME ${ENV_LAYER_NAME})
ENDIF()

SET(ENV_IMAGE_LAYER_FILE ${ENV_BASE_DIR}/${ENV_IMAGE_LAYER}/${ENV_IMAGE_LAYER_NAME})

IF (NOT ENV_IMAGE_DIR)
   SET(ENV_IMAGE_DIR ${ENV_BASE_DIR}/${ENV_RELEASE}${ENV_VIRT_MODE}-image${ENV_FLAVOR_SUFFIX})
ENDIF()

IF (NOT ENV_IMAGE_NAME)
   SET(ENV_IMAGE_NAME rootfs.img)
ENDIF()

IF (NOT ENV_IMAGE_SIZE)
   SET(ENV_IMAGE_SIZE 4G)
ENDIF()

# Image format: [qcow2, raw]
IF (NOT ENV_IMAGE_FORMAT)
   SET(ENV_IMAGE_FORMAT qcow2)
ENDIF()

# save into layer/image and check in tests
IF (NOT ENV_CHECK_ARCADIA_PATH)
   SET(ENV_CHECK_ARCADIA_PATH ${ENV_BASE_DIR})
ENDIF()
