IF (LINUX)

EXECTEST()

IF (NOT ENV_VIRT_MODE)
    SET(ENV_VIRT_MODE vm)
ENDIF()

INCLUDE(common.inc)

DEPENDS(
    ${QEMU_BIN_ROOT}
    infra/qemu/vmexec
    infra/environments/builder
    ${ENV_IMAGE_DIR}
)

IF (NOT ENV_RELEASE)
    DATA(arcadia/${ENV_SCRIPT_DIR})
    SET(ENV_CHECK_SCRIPT_OPT --check-script ${ARCADIA_ROOT}/${ENV_SCRIPT_DIR})
ENDIF()

RUN(NAME inspect_image
    vmexec
    -S ${ARCADIA_ROOT}
    -B ${ARCADIA_BUILD_ROOT}
    -I ${ARCADIA_BUILD_ROOT}/${ENV_IMAGE_DIR}/${ENV_IMAGE_NAME}
    --
    ${ARCADIA_BUILD_ROOT}/infra/environments/builder/builder inspect
    --current
    --check-arcadia-path ${ENV_CHECK_ARCADIA_PATH}
    --check-virt-mode ${ENV_VIRT_MODE}
    --check-flavor ${ENV_FLAVOR}
    --check-network dist.yandex.net:80
    ${ENV_CHECK_SCRIPT_OPT}
)

TIMEOUT(120)
SIZE(MEDIUM)
REQUIREMENTS(
    kvm
    network:full
)
END()

ENDIF() # LINUX
