IF (NOT ENV_VIRT_MODE)
   SET(ENV_VIRT_MODE vm)
ENDIF()

INCLUDE(common.inc)

# Build image for non-persitent data (without journal)
IF (ENV_IMAGE_EPHEMERAL)
   SET(ENV_BUILDER_EPHEMERAL_OPT --ephemeral)
ENDIF()

PEERDIR(
   ${ENV_BUILDER_WRAPPER_PEERDIR}
   ${ENV_BUILDER_PEERDIR}
   ${QEMU_BIN_ROOT}
   ${ENV_BASE_DIR}/${ENV_IMAGE_LAYER}
)

IF (NOT AUTOCHECK)

RUN_PROGRAM(${ENV_BUILDER_WRAPPER_TOOL} ${ENV_BUILDER_WRAPPER_ARGS}
      ${ENV_BUILDER_TOOL} build-image
      --size ${ENV_IMAGE_SIZE}
      --out-fmt ${ENV_IMAGE_FORMAT}
      --out ${ENV_IMAGE_NAME}
      --qemu-img-tool ${QEMU_IMG_TOOL}
      ${ENV_BUILDER_EPHEMERAL_OPT}
      ${ENV_IMAGE_LAYER_FILE}

   IN ${ENV_BUILDER_WRAPPER_IN}
      ${ENV_BUILDER_IN}
      ${QEMU_IMG_TOOL}
      ${ENV_IMAGE_LAYER_FILE}

   TOOL ${ENV_BUILDER_TOOL}

   OUT ${ENV_IMAGE_NAME}
   STDOUT_NOAUTO ${ENV_BUILD_LOG}
)

ENDIF() # AUTOCHECK
