IF (LINUX)

EXECTEST()

IF (NOT ENV_VIRT_MODE)
    SET(ENV_VIRT_MODE app)
ENDIF()

INCLUDE(common.inc)

DEPENDS(
    ${ENV_LAYER_DIR}
    ${ENV_BUILDER_PEERDIR}
    ${ENV_BUILDER_WRAPPER_PEERDIR}
    # devtools/dummy_arcadia/recipe/path_preload
)

IF (NOT ENV_RELEASE)
    DATA(arcadia/${ENV_SCRIPT_DIR})
    SET(ENV_CHECK_SCRIPT_OPT --check-script ${ARCADIA_ROOT}/${ENV_SCRIPT_DIR})
ENDIF()

# sandbox has no zstd =( run in vmexec
# USE_RECIPE(devtools/dummy_arcadia/recipe/path_preload/path_preload /bin/tar /bin/gzip /usr/bin/zstd)

RUN(
    NAME inspect_layer
    vmexec
    --qemu-bin ${ARCADIA_BUILD_ROOT}/${QEMU_BIN_APP}
    --rootfs ${ENV_VMEXEC_ROOTFS}/${ENV_VMEXEC_ROOTFS_NAME}
    --vcpus ${ENV_VMEXEC_VCPUS}
    --arcadia-source ${ARCADIA_ROOT}
    --arcadia-build ${ARCADIA_BUILD_ROOT}
    --
    ${ARCADIA_BUILD_ROOT}/${ENV_BUILDER_PEERDIR}/builder inspect
    --layer ${ARCADIA_BUILD_ROOT}/${ENV_LAYER_DIR}/${ENV_LAYER_NAME}
    --check-arcadia-path ${ENV_CHECK_ARCADIA_PATH}
    --check-virt-mode ${ENV_VIRT_MODE}
    --check-flavor ${ENV_FLAVOR}
    ${ENV_CHECK_SCRIPT_OPT}
)

TIMEOUT(120)
SIZE(MEDIUM)
REQUIREMENTS(
    kvm
    network:full
)

END()

ENDIF() # LINUX
