IF (NOT ENV_VIRT_MODE)
   SET(ENV_VIRT_MODE app)
ENDIF()

SET(ENV_VMEXEC_VOL_SECURITY 'mapped-file')

INCLUDE(common.inc)

IF (ENV_HTTP_PROXY)
   SET(ENV_HTTP_PROXY_OPT --env http_proxy=${ENV_HTTP_PROXY})
ENDIF()

PEERDIR(
   ${ENV_BUILDER_WRAPPER_PEERDIR}
   ${ENV_BUILDER_PEERDIR}
   ${ENV_BASE_LAYER_TARGETS}
)

IF (ENV_BASE_LAYER_TARGETS)
    SET(ENV_BUILDER_BASE_LAYER_ARGS --base-layer ${ENV_BASE_LAYER_FILES})
ENDIF()

IF (NOT AUTOCHECK)

RUN_PROGRAM(${ENV_BUILDER_WRAPPER_TOOL} ${ENV_BUILDER_WRAPPER_ARGS}
      ${ENV_BUILDER_TOOL} build-porto-layer
      --save-digest
      --env ${ENV_VAR}
      ${ENV_HTTP_PROXY_OPT}
      --out ${ENV_LAYER_NAME}
      --compress ${ENV_LAYER_COMPRESS}
      --log ${ENV_BUILD_LOG}
      --virt-mode ${ENV_VIRT_MODE}
      --arcadia-path ${ENV_BASE_DIR}
      ${ENV_BUILDER_ARCADIA_CHROOT_ARGS}
      ${ENV_BUILDER_BASE_LAYER_ARGS}
      --
      ${ARCADIA_ROOT}/${ENV_SCRIPT_DIR}

   TOOL ${ENV_BUILDER_TOOL}

   IN ${ENV_BUILDER_WRAPPER_IN}
      ${ENV_BUILDER_IN}
      ${ENV_BASE_LAYER_INPUTS}
      ${ENV_SCRIPT_DIR}/SHA1SUMS

   OUT ${ENV_LAYER_NAME}
   OUT_NOAUTO ${ENV_BUILD_LOG}
)

ENDIF() # AUTOCHECK
