#!/bin/bash

DIR=$(dirname $0)
ENV_ROOT=$(realpath $DIR/..)

kver=$1

if [ "$kver" = "" -o "$kver" = "-h" ]
then
    echo "Usage $0 kernel-revision"
    echo "Current versions"
    for f in $(find $ENV_ROOT -name config-experimental.inc)
    do
	grep ENV_KERNEL_VERSION $f
    done
    exit 1
fi
ya make  $ENV_ROOT/builder
for f in $(find $ENV_ROOT -name config-experimental.inc)
do
    sed -i "s/DEFAULT(ENV_KERNEL_VERSION  *.*)/DEFAULT(ENV_KERNEL_VERSION $kver)/g" $f
    $ENV_ROOT/builder/builder list-pack -s `dirname $(dirname $f)`
done
