#!/bin/sh -ex

#ENV_BASE_DIR=$(ya tool svn info --show-item relative-url | sed 's#^\^/trunk/arcadia/##')
ENV_BASE_DIR=$(realpath . | sed "s#^$(ya dump root)/##")

test -d script

TARGETS=""

COMPRESS="gz"
grep -q -w "layer.tar.zst" script/config/config.inc && COMPRESS="zst"

for layer in *-layer* ; do
	test -d $layer
	TARGETS="$TARGETS $layer/layer.tar.$COMPRESS"
done

for image in *-image* ; do
	test -d $image
	TARGETS="$TARGETS $image/rootfs.img"
done

test -n "$TARGETS"

ya tool sandboxctl ya-make -A -W \
	-c resource_compress=False \
	-c resource_archive_check=True \
	-c release_on_success=True \
	-c release_status=stable \
	$TARGETS
