#!/bin/sh -ex

owner="g:kernel"

make_target() {

  virt_mode=$1
  type=$2
  flavor=$3
  output=$4

  base_dir=$(realpath . | sed "s#^$(ya dump root)/##")

  if [ -n "$flavor" ] ; then
    flavor_suffix="-$flavor"
  fi

  dir="${virt_mode}-${type}${flavor_suffix}"
  cfg="config${flavor_suffix}.inc"

  test ! -d "${dir}"

  if [ ! -f $cfg ] ; then

    cat >$cfg <<EOF
SET(ENV_BASE_DIR $base_dir)
# SET(ENV_BASE_LAYER infra/environments/__base__/release/${virt_mode}-layer)
# SET(ENV_IMAGE_SIZE 4G)
EOF

    if [ -n "$flavor" ] ; then
      echo "SET(ENV_FLAVOR $flavor)" >> $cfg
    fi

  fi

  mkdir "$dir"

  cat >"$dir/ya.make" <<EOF
PACKAGE()
OWNER($owner)
SET(ENV_VIRT_MODE $virt_mode)
INCLUDE(../$cfg)
INCLUDE(\${ARCADIA_ROOT}/infra/environments/lib/${type}.inc)
END()

RECURSE_FOR_TESTS(test)
EOF

  mkdir "$dir/test"
  cat >"$dir/test/ya.make" <<EOF
OWNER(g:kernel)
SET(ENV_VIRT_MODE vm)
INCLUDE(../../$cfg)
INCLUDE(\${ARCADIA_ROOT}/infra/environments/lib/${type}-test.inc)
EOF

  mkdir -p "release/$dir"
  cat >"release/$dir/ya.make" <<EOF
UNION()
OWNER($owner)
FROM_SANDBOX(00000000 OUT $output AUTOUPDATED $output)
END()

RECURSE_FOR_TESTS(test)
EOF

  cat >"release/$dir/ya.make.autoupdate" <<EOF
{
    "$output": {
        "resource_type": "ARCADIA_PROJECT_TGZ",
        "attributes": {
            "arcadia_path": "$base_dir/$dir/$output",
            "released": "stable"
        }
    }
}
EOF

  mkdir "release/$dir/test"
  cat >"release/$dir/test/ya.make" <<EOF
OWNER($owner)
SET(ENV_VIRT_MODE ${virt_mode})
INCLUDE(../../../$cfg)
INCLUDE(${ARCADIA_ROOT}/infra/environments/lib/${type}-test-release.inc)
EOF

  echo "done $dir"
}

case "$1"  in
vm)
   make_target "vm" "layer" "$2" "layer.tar.gz"
   make_target "vm" "image" "$2" "rootfs.img"
   ;;
os)
   make_target "os" "layer" "$2" "layer.tar.gz"
   ;;
app)
   make_target "app" "layer" "$2" "layer.tar.gz"
   ;;
*)
   echo "usage: $0 <vm|os|app> [flavor]"
   ;;
esac
