#!/bin/sh

export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"

: ${NCCL_VERSION="2.8.3-1+cuda11.0"}
: ${NCCL_TESTS_RESOURCE="2407230820"}
: ${NCCL_TESTS_VERSION="v2.10.1-3-ga2fa4d5f0443"}

## ML_DEV part
${APT_GET} install \
	   libnccl-dev=${NCCL_VERSION} \
	   libnl-3-200

. /opt/hpcx/ompi-ipv6.sh
hpcx_load
curl https://proxy.sandbox.yandex-team.ru/${NCCL_TESTS_RESOURCE} | tar zvx -C /opt
make -C  /opt/nccl-tests-${NCCL_TESTS_VERSION} MPI=1 -j4
ln -s /opt/nccl-tests-${NCCL_TESTS_VERSION} /opt/nccl-tests
hpcx_unload
