#!/bin/bash -e

###############################################################################

export DEBIAN_FRONTEND=noninteractive

source /etc/lsb-release
OS=$DISTRIB_CODENAME
nvidia_version=450.80.02-0
cuda_version=10.1.105-1
WGET_TRIES=5
APT_GET="apt-get --yes --no-install-recommends --allow-unauthenticated --allow-downgrades"

get_pkgs_urls() {
    local repo=$1
    local pattern=$2
    local dist_url="http://dist.yandex.ru"
    local url_prefix="$dist_url/$repo-$OS/unstable/amd64"

    wget --quiet --tries=5 -O - "$url_prefix/Packages.gz" | gunzip - | grep ${pattern} | perl -pe "s#Filename: #$url_prefix#g"
}

install_package() {
    local package=${1}

    # echo "$ dpkg -i --force-all $package"
    # dpkg -i --force-all ./$package
    echo "$ apt install --yes --fix-broken --no-install-recommends ./$package"
    apt install --yes --fix-broken --no-install-recommends ./$package
    echo "$ rm -rf $package"
    rm -f $package
}


###############################################################################
# Install CUDA
###############################################################################

nvidia_version_major=${nvidia_version%.*.*} # a.b -> a
cuda_version_major=${cuda_version%.*.*} #a.b.c -> a
cuda_version_major_minor=${cuda_version%.*} #a.b.c -> a.b
cuda_version_code=${cuda_version_major_minor//./-} #a.b -> a-b

cublas_version="${cuda_version%.*}.0.${cuda_version##*.}"

cuda_packages=()

tee /etc/apt/sources.list.d/nvidia.list <<EOF
deb http://dist.yandex.ru/nvidia-drivers-$OS unstable/amd64/
deb http://dist.yandex.ru/nvidia-drivers-bionic unstable/amd64/
deb http://dist.yandex.ru/nvidia-ml-$OS unstable/amd64/
EOF

apt-get update

cuda_packages+=("cuda-license-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-driver-dev-${cuda_version_code}_${cuda_version}_amd64.deb")
# DO NOT INSTALL libcuda1 with 450+ drivers!!!
#cuda_packages+=("libcuda1-${nvidia_version_major}_${nvidia_version}ubuntu1_amd64.deb")
cuda_packages+=("libcublas${cuda_version_major}_${cublas_version}_amd64.deb")
cuda_packages+=("libcublas-dev_${cublas_version}_amd64.deb")
cuda_packages+=("cuda-cufft-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cufft-dev-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cusolver-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cusolver-dev-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-curand-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-curand-dev-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cudart-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cudart-dev-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cusparse-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cusparse-dev-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-misc-headers-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-nvcc-${cuda_version_code}_${cuda_version}_amd64.deb")
cuda_packages+=("cuda-cupti-${cuda_version_code}_${cuda_version}_amd64.deb")

mkdir -p /usr/lib/nvidia

printf -v cuda_pattern -- "-e %s " "${cuda_packages[@]}"

cuda_pkgs_urls=$(get_pkgs_urls "nvidia-drivers" "${cuda_pattern}")

for url in $cuda_pkgs_urls
do
    wget --quiet --tries=$WGET_TRIES "$url"
done;

for package in ${cuda_packages[*]}
do
    install_package $package
done;

###############################################################################
# Configure dynamic linker
###############################################################################

cuda_conf=/etc/ld.so.conf.d/cuda-${cuda_version_major_minor}.conf
echo /usr/local/cuda-${cuda_version_major_minor}/lib64 > "${cuda_conf}"
echo /usr/lib/x86_64-linux-gnu >> "${cuda_conf}"

nvidia_conf=/etc/ld.so.conf.d/nvidia-${nvidia_version_major}.conf
echo /usr/lib/nvidia-${nvidia_version_major} > "${nvidia_conf}"

ldconfig

ln -s /usr/local/cuda-${cuda_version_major_minor} /usr/local/cuda
