#!/bin/bash

export DEBIAN_FRONTEND=noninteractive
APT_GET="apt-get --yes --no-install-recommends --allow-unauthenticated --allow-downgrades"

source /etc/lsb-release
OS=$DISTRIB_CODENAME

nvidia_version=450.119.04-0
nvidia_version_major=${nvidia_version%.*.*}

tee /etc/apt/sources.list.d/nvidia.list <<EOF
deb http://dist.yandex.ru/nvidia-drivers-$OS unstable/amd64/
deb http://dist.yandex.ru/nvidia-drivers-bionic unstable/amd64/
deb http://dist.yandex.ru/nvidia-ml-$OS unstable/amd64/
EOF

apt-get update

$APT_GET install \
"libnvidia-compute-${nvidia_version_major}=${nvidia_version}ubuntu1" \
"libnvidia-cfg1-${nvidia_version_major}=${nvidia_version}ubuntu1" \
"nvidia-common=1:0.4.17.7" \
"nvidia-kernel-source-${nvidia_version_major}=${nvidia_version}ubuntu1" \
"yandex-nvidia-utils=0.2-8573171"


