#!/bin/bash

DIR=$(dirname $0)
. $DIR/setenv.sh

ucx_hcoll="--mca coll ^hcoll -mca coll_hcoll_enable 0 -x NCCL_COLLNET_ENABLE=0"
ucx_args="--mca btl ^openib -mca pml ucx $ucx_hcoll"

ompi_spawn_args=" -mca plm_rsh_num_concurrent 300 -mca routed_radix 600 -mca plm_rsh_no_tree_spawn 1 -mca pmix_base_async_modex 1" 
ompi_tcp_args='-mca oob_tcp_if_include veth -x NCCL_SOCKET_IFNAME=veth'
ompi_genric_args="--prefix $MPI_HOME -x LD_LIBRARY_PATH --allow-run-as-root --bind-to none -mca orte_keep_fqdn_hostnames true"
export MPIRUN_CMD="mpirun $ompi_genric_args  $ompi_tcp_args $ompi_spawn_args $ucx_args -x HPC_WORKSPACE"

echo $MPIRUN_CMD $@
$MPIRUN_CMD $@
