
DIR=`pwd`

export HPCX_HOME=/opt/hpcx
export NVLIBS=/opt/yandex-nvidia-utils/`cat /sys/module/nvidia/version`
source ${HPCX_HOME}/ompi-ipv6.sh
hpcx_load

# HPC_BENCHMARK speciffic config
export HPC_BENCH_HOME=/opt/hpc-benchmarks
export HPC_WORKSPACE=${HPC_BENCH_HOME}/workspace
export CUDA_HOME=${HPC_BENCH_HOME}/usr/local/cuda-11.2
export MKL_HOME=${HPC_BENCH_HOME}/opt/intel/compilers_and_libraries_2020.4.304/linux/mkl/lib/intel64_lin


export PATH=${CUDA_HOME}/bin:${PATH}
export LD_LIBRARY_PATH=${CUDA_HOME}/lib64:${CUDA_HOME}/compat:${NVLIBS}:${MKL_HOME}:${LD_LIBRARY_PATH}

# For /usr/lib/x86_64-linux-gnu/libgfortran.so.3
export LD_LIBRARY_PATH=/opt/hpc-benchmarks-cfg/app/lib:${LD_LIBRARY_PATH}

echo " CUDA Toolkit Version: $(nvcc -V)"
echo 
echo " Loaded HPCX: ${HPCX_HOME}"
echo 
echo " UCX Version: $(ucx_info -v)"
echo 
echo "OMPI Version: $(ompi_info --version)"

