# do not log secrets
set +x

export root_password_encrypted='$6$WHMzi5254$CqSs/KS6wTUWUAvDkn8uYaLnoE/IrtuHx2xqEcLZ1uYgpQr5ON0eCt9Y8LleIb6MCLs4st/dQy.jjt.7.bE75/'
export root_authorized_keys='ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQDgNxPAC4/ME00F8fRcVTxFEqq1a8Qc9tFYNuWM/7FX4nkpvLlaEZuBVTVEyA6E2IqAymdBKJXnGLO6tykFJONvIbXzYUeFhDrWDUBYaEGKQpg36Mv4lk37CedDaucO2VoURm90N74Hn0JUDRUQMHFnEG38/4kTeRdYcNOV6gF1bw== qvm-qa-key'

export guest_user='qemu'
export guest_password_encrypted='$6$OCnWRIUk$Hyjthen.BhEY9KiGYYWwRW2TxYYRkBhS5O9DeJzqto2kbZP9Tbaati.Ct8if6VdHuvs6wWttnGg5O2NFRrNkr1'
export guest_authorized_keys='ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQDgNxPAC4/ME00F8fRcVTxFEqq1a8Qc9tFYNuWM/7FX4nkpvLlaEZuBVTVEyA6E2IqAymdBKJXnGLO6tykFJONvIbXzYUeFhDrWDUBYaEGKQpg36Mv4lk37CedDaucO2VoURm90N74Hn0JUDRUQMHFnEG38/4kTeRdYcNOV6gF1bw== qvm-qa-key'


# hint: encrypt with mkpasswd -m sha-512
if [ -n "$root_password_encrypted" ] ; then
	echo "root:$root_password_encrypted" | chpasswd --encrypted
fi

if [ -n "$root_authorized_keys" ] ; then
	mkdir -p root/.ssh
	chmod 0700 root/.ssh
	echo "$root_authorized_keys" >> root/.ssh/authorized_keys
	chmod 0600 root/.ssh/authorized_keys
fi


# hint: encrypt with mkpasswd -m sha-512
if [ -n "$guest_user" ] ; then
    useradd $guest_user
    echo "$guest_user:$guest_password_encrypted" | chpasswd --encrypted
    usermod -aG sudo $guest_user
    echo "$guest_user ALL=(ALL) NOPASSWD:ALL" | sudo tee -a etc/sudoers
    visudo -c
    if [ -n "$guest_authorized_keys" ] ; then
	mkdir -p home/$guest_user/.ssh
	chown $guest_user:$guest_user  home/$guest_user/.ssh
	chmod 0700 home/$guest_user/.ssh
	echo "$guest_authorized_keys" >> home/$guest_user/.ssh/authorized_keys
	chown $guest_user:$guest_user  home/$guest_user/.ssh/authorized_keys
	chmod 0600 root/.ssh/authorized_keys
    fi
fi

set -x
