#!/bin/sh

[ "$virt_mode" != "vm" ] && exit 0
[ "$dev" != "t" ] && exit 0

# dev packages
export DEBIAN_FRONTEND="noninteractive"

APT_GET="apt-get --yes --no-install-recommends --allow-downgrades"

tee /etc/apt/sources.list.d/mirror.list <<EOF
deb http://mirror.yandex.ru/ubuntu xenial main restricted universe multiverse
deb http://mirror.yandex.ru/ubuntu xenial-security main restricted universe multiverse
deb http://mirror.yandex.ru/ubuntu xenial-updates main restricted universe multiverse
EOF

apt-get update

$APT_GET install \
build-essential \
cmake \
libc6-dbg \
gdb \
gdbserver \
subversion \
git \
cvs \
screen \
tmux \
man \
ack-grep \
apt-file \
autoconf \
cgdb \
clang \
cmake \
colordiff \
cscope \
emacs \
exuberant-ctags \
g++ \
gcc \
ghostscript \
git-svn \
glibc-doc \
global \
graphviz \
graphviz-dev \
libblas-dev \
libjpeg8-dev \
liblapack-dev \
libpng-dev \
mercurial \
mosh \
nano \
ncdu \
perl-doc \
pigz \
pychecker \
python-bsddb3 \
python-dev \
python-lxml \
python-mysqldb \
python-numpy \
python-pip \
python-pysqlite2 \
python-scipy \
python-tk \
python-virtualenv \
screen \
tmux \
valgrind \
devscripts \
patch \
zip \
llvm \
lldpd \
cifs-utils \
vim \
time \
fuse \
yandex-internal-root-ca \
yandex-repo-yt-common \
yandex-repo-yt-common \
yandex-search-coredump-watcher

if [ $(lsb_release -c -s) == "precise" ]; then
  $APT_GET install g++-4.7 gcc-4.7 realpath
elif [ $(lsb_release -c -s) == "trusty" ]; then
  $APT_GET install g++-4.7 g++-4.8 gcc-4.7 gcc-4.8 realpath
elif [ $(lsb_release -c -s) == "xenial" ]; then
  $APT_GET install g++-4.7 g++-4.8 g++-4.9 gcc-4.7 gcc-4.8 gcc-4.9 realpath
elif [ $(lsb_release -c -s) == "bionic" ]; then
  $APT_GET install g++-4.8 gcc-4.8
fi

