[ "$virt_mode" != "vm" ] && exit 0

export DEBIAN_FRONTEND="noninteractive"

apt-get --allow-downgrades --quiet --yes --no-install-recommends install isc-dhcp-client="4.3.3-5ubuntu12.10" ifupdown="0.8.10ubuntu1.4" acpid="1:2.0.26-1ubuntu2" net-tools="1.60-26ubuntu1"

rm -fv /etc/dhcp/dhclient-enter-hooks.d/resolved || true


apt-get --quiet --yes --allow-downgrades --no-install-recommends install cloud-init="20.2-45-g5f7825e2-0ubuntu1~16.04.1"

tee /etc/sysctl.d/30-eth0.conf <<EOF
net.ipv6.conf.eth0.autoconf=1
net.ipv6.conf.eth0.accept_ra=2
EOF
systemctl enable systemd-sysctl

tee /etc/cloud/cloud.cfg.d/90_dpkg.cfg <<EOF
# to update this file, run dpkg-reconfigure cloud-init
datasource_list: [ NoCloud, ConfigDrive ]
EOF

echo 'source /etc/network/interfaces.d/*.cfg' > /etc/network/interfaces

# for 41_set_root_secrets.sh
tee etc/cloud/cloud.cfg.d/99_enable_root.cfg <<EOF
disable_root: false
EOF

tee /etc/cloud/cloud.cfg.d/99_eni.cfg <<EOF
system_info:
  network:
    renderers: ['eni']
EOF

systemctl enable networking.service

systemctl mask systemd-network-generator.service
systemctl mask systemd-networkd-wait-online.service
systemctl mask systemd-networkd.service
systemctl mask systemd-resolved.service
systemctl mask systemd-networkd.socket

