set -x
[ "$virt_mode" != "vm" -a "$virt_mode" != "os" ] && exit 0
[ "$subagent" = "t" ] && exit 0

export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends --allow-unauthenticated --allow-downgrades"

$APT_GET install yandex-gosky='2.1.2'

/Berkanavt/skynet/bin/gosky; if [[ $? -eq 12 || $? -eq 0 ]]; then echo 'true'; else echo 'false'; fi
# Skynet
s_stop () {
  /etc/init.d/$1 stop || true
  service $1 stop || true
  systemctl stop $1 || true
}

s_stop cron
/usr/local/bin/skyctl stop || true
s_stop skycored
/usr/local/bin/skyctl shutdown --stop-services || true
echo 'cleanup: sleeping 30 seconds to ensure skynet down'
sleep 30
# dirty hack to ensure skynet stopped
if [[ "$virt_mode" == "qemu" ]]; then
  sleep 300
fi
ps auxf | grep [s]kycore && exit 1
find /place/berkanavt/supervisor/var/ -type f -exec rm -r "{}" \; || true
rm -rf /place/berkanavt/supervisor/etc/auth/* || true

# Clean history
> /root/.bash_history

# QEMUKVM-426
if [ $(stat -c "%u%g" /) != 00 ]; then chown root:root /; fi || true
for signal in 15 9 ; do
    for p in /proc/[0-9]*; do
        p=$(basename $p)
        ppid=$(grep 'PPid' /proc/$p/status 2>/dev/null | awk '{print $2}')
        if ( ! grep -q '/dev/vda' /proc/$p/mountinfo 2>/dev/null ) && [ "$ppid" == "1" ]; then
            echo "killing pid $p with $signal"
            kill -$signal $p
        fi
    done
    sleep 3
done
umount /var/tmp/skynet/cqudp || true

