# local mirror
: ${python_pip_url="https://pypi.yandex-team.ru/simple"}

: ${with_python2="1"}
: ${with_python3="1"}

tee /etc/pip.conf <<EOF
[global]
index-url = ${python_pip_url}
timeout = 120
EOF

export DEBIAN_FRONTEND="noninteractive"

if [ "$with_python2" = "1" ] ; then
	apt-get --quiet --yes --no-install-recommends install \
		python \
		python-dev \
		python-pip \
		cython
	pip install --upgrade --index-url=${python_pip_url} pip

	python -V
fi

if [ "$with_python3" = "1" ] ; then
	apt-get --quiet --yes --no-install-recommends install \
		python3.5 \
		python3.5-dev \
		python3-six/unstable \
		python3-pip

	python3.5 -m pip --version
	python3.5 -m pip install --no-use-wheel --upgrade --index-url=${python_pip_url} setuptools
	python3.5 -m pip install --no-use-wheel --upgrade --index-url=${python_pip_url} six
	python3.5 -m pip install --no-use-wheel --upgrade --index-url=${python_pip_url} pip
	python3.5 -m pip --version
	apt-get remove --yes --purge '^python3.2'
	update-alternatives --install /usr/bin/python3 python3 /usr/bin/python3.5 1

	pip3 install --upgrade --index-url=${python_pip_url} cython

	python3 -V
fi
