export DEBIAN_FRONTEND="noninteractive"

# for cron, logrotate, rsyslog
DIVERTS="usr/sbin/invoke-rc.d"

for file in $DIVERTS; do
	dpkg-divert --add --rename --local --divert /${file}.orig /${file}
	ln -s /bin/true $file
done


apt-get --quiet --yes --no-install-recommends install \
bc \
binutils \
bsd-mailx \
bsdmainutils \
bzip2 \
cron \
curl \
daemon \
dnsutils \
ethtool \
file \
fuse \
iptables \
iputils-ping \
iputils-tracepath \
less \
lockfile-progs \
logrotate \
lsb-release \
lsof \
m4 \
man \
netbase \
netcat-openbsd \
net-tools \
ntpdate \
openssh-client \
perl \
pigz \
psmisc \
python \
rsync \
rsyslog \
sudo \
tar \
tcpdump \
vim \
vmtouch \
wget \
xz-utils \
zstd


if [ "$virt_mode" == "vm" ] ; then
	apt-get --quiet --yes --no-install-recommends install \
		e2fsprogs \
		gdisk \
		lvm2 \
		parted
fi


for file in $DIVERTS; do
	rm -f ${file}
	dpkg-divert --remove --rename /${file}
done
