#!/bin/sh

[ "$virt_mode" != "vm" ] && exit 0
# Versions from
# https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/browse/common/components/nvidia
# From https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/browse/common/components/nvidia/driver-450-v1/init.sls
: ${NVIDIA_PACKAGE="nvidia-450"}
: ${NVIDIA_PACKAGE_VER="450.80.02-yandex2"}

: ${NVIDIA_DEV_PACKAGE="nvidia-450-dev"}
: ${NVIDIA_DEV_PACKAGE_VER="450.80.02-0ubuntu1"}

: ${NVIDIA_MODPROBE_PACKAGE="nvidia-modprobe"}
: ${NVIDIA_MODPROBE_PACKAGE_VER="450.80.02-0ubuntu1"}

: ${NVIDIA_LIBCUDA_PACKAGE="libcuda1-450"}
: ${NVIDIA_LIBCUDA_PACKAGE_VER="450.80.02-0ubuntu1"}
export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"


# For yandex-search-common-apt
tee etc/apt/sources.list.d/nvidia-drivers.list <<EOF
deb http://nvidia-drivers-xenial.dist.yandex.ru/nvidia-drivers-xenial unstable/amd64/
deb http://nvidia-drivers-xenial.dist.yandex.ru/nvidia-drivers-xenial unstable/all/
EOF

apt-get update -y
apt-get remove --yes --purge cuda-repo-ubuntu1604  || /bin/true

apt-get update -y
apt-cache policy nvidia-common
$APT_GET install  nvidia-common


$APT_GET install ${NVIDIA_PACKAGE}=${NVIDIA_PACKAGE_VER} \
	 ${NVIDIA_DEV_PACKAGE}=${NVIDIA_DEV_PACKAGE_VER} \
	 ${NVIDIA_MODPROBE_PACKAGE}=${NVIDIA_MODPROBE_PACKAGE_VER} \
	 ${NVIDIA_LIBCUDA_PACKAGE}=${NVIDIA_LIBCUDA_PACKAGE_VER}
