#!/bin/sh

[ "$WITH_NCCL_DEV" != "t" ] && exit 0
export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"

: ${OMPI_RESOURCE="1527804358"}
: ${OMPI_VERSION="v4.0.3"}

: ${NCCL_RESOURCE="1527808775"}
: ${NCCL_VERSION="v2.6.4-1"}

: ${NCCL_TESTS_RESOURCE="1527811331"}
: ${NCCL_TESTS_VERSION="v1.0.0-5-gc864b73"}

apt-get update
${APT_GET} install automake autoconf libtool flex

curl https://proxy.sandbox.yandex-team.ru/${OMPI_RESOURCE} | zstdcat | tar vx -C /opt
pushd /opt/ompi-${OMPI_VERSION}
./autogen.pl
./configure --prefix=/usr
make -j
make install PREFIX=/usr
popd

curl https://proxy.sandbox.yandex-team.ru/${NCCL_RESOURCE} | zstdcat | tar vx -C /opt
make -C  /opt/nccl-${NCCL_VERSION} -j4 src.build NVCC_GENCODE="-gencode=arch=compute_70,code=sm_70"
make -C  /opt/nccl-${NCCL_VERSION} install PREFIX=/usr

curl https://proxy.sandbox.yandex-team.ru/${NCCL_TESTS_RESOURCE} | zstdcat | tar vx -C /opt
make -C  /opt/nccl-tests-${NCCL_TESTS_VERSION} -j4

