#!/bin/sh

[ "$WITH_ML" != "t" ] && exit 0
export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"

: ${NCCL_VERSION="2.8.3-1+cuda11.0"}
: ${NCCL_TESTS_RESOURCE="2407230820"}
: ${NCCL_TESTS_VERSION="v2.10.1-3-ga2fa4d5f0443"}
: ${HPCX_VERSION="hpcx-v2.8.1-gcc-MLNX_OFED_LINUX-5.1-0.6.6.0-ubuntu16.04-x86_64-ipv6"}
: ${HPCX_RESOURCE="2266038380"}


apt-get install --yes build-essential binutils-dev hwloc libnuma-dev

# Rebuild openmpi with ipv6 support
curl https://proxy.sandbox.yandex-team.ru/${HPCX_RESOURCE} | tar -zxv -C /opt
ln -s /opt/${HPCX_VERSION} /opt/hpcx

pushd /opt/hpcx
ompi_prefix=ompi-ipv6 ./utils/hpcx_rebuild.sh --cuda --with-hcoll --ompi-extra-config '--enable-ipv6' || /bin/true
popd

${APT_GET} install \
	   numactl \
	   libnuma-dev \
	   libnccl2=${NCCL_VERSION}

[ "$WITH_ML_DEV" != "t" ] && exit 0
## ML_DEV part
${APT_GET} install \
	   libnccl-dev=${NCCL_VERSION}

. /opt/hpcx/ompi-ipv6.sh
hpcx_load
curl https://proxy.sandbox.yandex-team.ru/${NCCL_TESTS_RESOURCE} | tar zvx -C /opt
make -C  /opt/nccl-tests-${NCCL_TESTS_VERSION} MPI=1 -j4
ln -s /opt/nccl-tests-${NCCL_TESTS_VERSION} /opt/nccl-tests
hpcx_unload
