# ${CURDIR} relative to ${ARCADIA_ROOT}
SET(ENV_LAYER_NAME layer.tar.zst)
SET(ENV_BASE_DIR infra/environments/rtc-xenial)
# Enable nat64dns
SET_APPEND(ENV_VAR with_nat64=t)

SET(ENV_FLAVOR experimental)

IF (KERN_TEST)

    # install test kernel
    SET_APPEND(ENV_VAR KERN_TEST=1)

    SET_APPEND(CUSTOM_RESOURCE_LIST ${LINUX_IMAGE_SERVER_RESOURCE})
    SET_APPEND(CUSTOM_RESOURCE_LIST ${LINUX_IMAGE_EXTRA_RESOURCE})
    SET_APPEND(CUSTOM_RESOURCE_LIST ${LINUX_TOOLS_RESOURCE})
    SET_APPEND(CUSTOM_RESOURCE_LIST ${LINUX_IMAGE_RESOURCE})
    SET_APPEND(CUSTOM_RESOURCE_LIST ${LINUX_HEADERS_RESOURCE})

    SET_APPEND(ENV_VAR CUSTOM_RESOURCE_LIST='\"${CUSTOM_RESOURCE_LIST}\"')

    SET_APPEND(KERNEL_PACKAGE ./${LINUX_IMAGE_SERVER_FILENAME}\ )
    SET_APPEND(KERNEL_PACKAGE ./${LINUX_IMAGE_EXTRA_FILENAME}\ )
    SET_APPEND(KERNEL_PACKAGE ./${LINUX_TOOLS_FILENAME}\ )
    SET_APPEND(KERNEL_PACKAGE ./${LINUX_IMAGE_FILENAME}\ )
    SET_APPEND(KERNEL_PACKAGE ./${LINUX_HEADERS_FILENAME})

    SET_APPEND(ENV_VAR KERNEL_PACKAGE='\"${KERNEL_PACKAGE}\"')

ELSE()

    # install recent kernel
    DEFAULT(ENV_KERNEL_VERSION 5.4.196-37.1)
    DEFAULT(ENV_KERNEL_PACKAGE linux-image-server=${ENV_KERNEL_VERSION}\ linux-image-extra-${ENV_KERNEL_VERSION}\ linux-tools=${ENV_KERNEL_VERSION})
    SET_APPEND(ENV_VAR KERNEL_PACKAGE='\"${ENV_KERNEL_PACKAGE}\"')

ENDIF()

# install recent porto
SET_APPEND(ENV_VAR PORTO_PACKAGE=yandex-porto=5.0.3)
