[ "$virt_mode" != "vm" ] && exit 0

export DEBIAN_FRONTEND="noninteractive"

#apt-get --quiet --yes --no-install-recommends install debconf-utils
#debconf-set-selections <<EOF
#cloud-init	cloud-init/datasources	multiselect	NoCloud, ConfigDrive
#EOF

apt-get --quiet --yes --no-install-recommends install isc-dhcp-client

# do not rewrite /etc/resolv.conf from dhcp
tee etc/dhcp/dhclient-enter-hooks.d/keep_resolv_conf <<EOF
#!/bin/sh
make_resolv_conf() { : ; }
EOF
chmod +x etc/dhcp/dhclient-enter-hooks.d/keep_resolv_conf


apt-get --quiet --yes --no-install-recommends install cloud-init

# for cloud-init/netplan
systemctl enable systemd-networkd

# from livecd-rootfs live-build/ubuntu-server/includes.binary/overlay/etc/netplan/00-installer-config.yaml
tee etc/netplan/00-installer-config.yaml <<EOF
# By default setup ipv4 by DHCP, ipv6 by SLAAC
# This config can be overwritten by cloud-init

network:
    version: 2
    ethernets:
        all-en:
            match:
                name: "en*"
            dhcp4: true
        all-eth:
            match:
                name: "eth*"
            dhcp4: true
EOF


# do not overwrite /etc/apt/sources.list
tee etc/cloud/cloud.cfg.d/98_apt_preserve_sources_list.cfg <<EOF
apt:
    preserve_sources_list: true
EOF


# for 41_set_root_secrets.sh
tee etc/cloud/cloud.cfg.d/99_enable_root.cfg <<EOF
disable_root: false
EOF
