export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"

set -xe

tee -a etc/cloud/templates/hosts.debian.tmpl <<EOF
169.254.169.254 metadata.google.internal
EOF


tee /etc/default/instance_configs.cfg.template <<EOF
[Daemons]
network_daemon = false
ip_forwarding_daemon = false
clock_skew_daemon = false

[InstanceSetup]
optimize_local_ssd = false
network_enabled = false
set_boto_config = false
set_host_keys = false
set_multiqueue = false

[IpForwarding]
ip_aliases = false
target_instance_ips = false

[NetworkInterfaces]
setup = false
ip_forwarding = false
EOF

chmod 0444 /etc/default/instance_configs.cfg.template


$APT_GET install \
	google-compute-engine-oslogin


tee /usr/bin/oslogin_iam_control <<EOF
#!/bin/bash

set -eou pipefail

function _log() {
    echo "$*" >&2
}

_log "Enable oslogin"
if ! google_oslogin_control status; then
    google_oslogin_control activate
fi
EOF

chmod 0755 /usr/bin/oslogin_iam_control


tee /lib/systemd/system/enable-oslogin.timer <<EOF
[Unit]
Description=Oslogin activation timer for IAM

[Timer]
OnBootSec=60
OnUnitActiveSec=3min

[Install]
WantedBy=timers.target
EOF


tee /lib/systemd/system/enable-oslogin.service <<EOF
[Unit]
Description=Oslogin activation for IAM

[Service]
ExecStart=/usr/bin/oslogin_iam_control
EOF


systemctl enable enable-oslogin.timer
