export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"

apt purge auditd
systemctl mask systemd-journald-audit.socket 

tee /etc/osquery.tag <<EOF
ycloud-svc-generic-config
EOF

$APT_GET install \
	osquery-vanilla='4.4.0.1' \
	osquery-yandex-generic-config='1.1.1.51'


# for compability with oslogin
tee /etc/osquery/packs/processes.conf <<EOF
{
  "platform": "linux",
  "version": "3.3.0",
  "queries": {
    "executions": {
      "query": "SELECT ps.pid pid, ps.path path, ps.cmdline cmdline, ps.cwd cwd, ps.parent parent, pss.path parent_path, ps.time time, ps.uid uid, ps.auid auid, u.username username, au.username as audit_user, h.sha256 sha256 FROM process_events ps LEFT JOIN users u ON ps.uid = u.uid LEFT JOIN (SELECT * from users WHERE uid < 2000000000) au ON ps.auid = au.uid LEFT JOIN hash h ON ps.path = h.path LEFT JOIN processes pss ON ps.parent = pss.pid;",
      "interval": 300,
      "description": "user_process_events"
    },
    "running": {
      "query": "SELECT pid, parent, uid, euid, path, cmdline, on_disk FROM processes;",
      "interval": 3600,
      "description": "changes in running processes"
    },
    "running_s": {
      "query": "SELECT pid, parent, uid, euid, path, cmdline, on_disk FROM processes;",
      "interval": 86400,
      "snapshot": true,
      "description": "running processes snapshot"
    }
  }
}
EOF

systemctl enable /usr/lib/systemd/system/osqueryd.service