# Check files present
FILES_TO_CHECK="/usr/bin/rsync /usr/bin/gawk"
for i in ${FILES_TO_CHECK}; do
    if [ ! -f $i ]; then
        echo "${i}: No such file or directory" >&1
        exit 1
    fi
done

# Check awk alternatives configuration 
if [ ! -L /etc/alternatives/awk ]; then
    echo "can't find /etc/alternatives/awk link!" >&2
    exit 1
fi

if [ "$(realpath /etc/alternatives/awk)" != "/usr/bin/gawk" ]; then
    echo "/etc/alternatives/awk should link to /etc/alternatives/awk" >&2
    exit 1
fi
