package main

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/fwmanager/internal/server"
)

var rootCmd = &cobra.Command{
	Use: "fwmanager",
}

func Execute() error {
	return rootCmd.Execute()
}

func init() {
	c := &server.Config{
		Addr: server.Addr,
	}
	cmdStart := &cobra.Command{
		Use: "start",
		Short: "Start fwmanager\n" +
			"fwmanager will fetch rnd repos and render it to restapi(json)",
		Args: cobra.NoArgs,
		RunE: func(cmd *cobra.Command, args []string) error {
			c.Debug = getDebugFromEnv()
			fw, err := server.CreateFwmanager(c)
			if err != nil {
				return err
			}
			return fw.Start()
		},
	}
	f := cmdStart.Flags()
	f.StringVar(&c.RepoPath, "repo", "", "path to repo")
	f.StringVar(&c.Addr, "addr", server.Addr, "server address")
	rootCmd.AddCommand(cmdStart)
	rootCmd.PersistentFlags().StringVar(&c.Hostname, "hostname", "-", "Hostname")
}

func getDebugFromEnv() bool {
	return os.Getenv("DEBUG") == "true"
}

func er(msg interface{}) {
	fmt.Println("Error:", msg)
	os.Exit(1)
}
