package api

import (
	"context"

	"github.com/go-chi/chi/v5"
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/infra/fwmanager/internal/httprpc"
	"a.yandex-team.ru/infra/fwmanager/internal/render"

	pb "a.yandex-team.ru/infra/fwmanager/proto"
)

func GetFw(ctx context.Context, reqCtx *pb.RequestCtx, req *pb.GetFWVersionsRequest) (*pb.GetFWVersionsReply, error) {
	resp, err := render.GetFwbyFQDN(req.Fqdn, req.Devices, req.Project)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func RouteRegister(mux *chi.Mux) {
	httprpc.New("POST", "/api/getfw").
		CorsAllowAll().
		WithHandler(func(ctx context.Context, reqCtx *pb.RequestCtx, req proto.Message) (proto.Message, error) {
			return GetFw(ctx, reqCtx, req.(*pb.GetFWVersionsRequest))
		}).
		WithWriterByAccepted().
		Mount(mux)

}
