package fetcher

import (
	"strings"

	"github.com/jasonlvhit/gocron"
)

const cronInterval = 600

func FetchOnce(SourceURL string) error {
	if SourceURL == "dummy" {
		return nil
	}
	if strings.Contains(SourceURL, "//bb.") || strings.Contains(SourceURL, "github") {
		return nil
	}
	return nil
}

func SetFetchCron() error {
	gocron.Every(cronInterval).Seconds().Do(FetchOnce)
	<-gocron.Start()
	return nil
}
