package httpserver

import (
	"a.yandex-team.ru/library/go/core/log"
	"context"
	"net/http"
	"time"

	"github.com/go-chi/chi/v5/middleware"
	"github.com/rs/cors"

	"github.com/go-chi/chi/v5"
)

const (
	readTimeout  = 5 * time.Second
	writeTimeout = 30 * time.Second
)

type Server struct {
	addr string
	mux  *chi.Mux
}

func NewHTTP(addr string) *Server {
	m := chi.NewMux()
	c := cors.AllowAll()
	m.Use(c.Handler)
	m.Mount("/debug", middleware.Profiler())
	return &Server{
		addr: addr,
		mux:  m,
	}
}

func (s *Server) Addr() string {
	return s.addr
}

func (s *Server) Bind(method, pattern string, h http.HandlerFunc) {
	s.mux.Method(method, pattern, h)
}

func (s *Server) Handle(pattern string, h http.Handler) {
	s.mux.Handle(pattern, h)
}

func (s *Server) Mux() *chi.Mux {
	return s.mux
}

func (s *Server) Run(ctx context.Context, l log.Logger) error {
	httpSrv := http.Server{
		Addr:         s.addr,
		Handler:      s.mux,
		ReadTimeout:  readTimeout,
		WriteTimeout: writeTimeout,
	}
	l.Infof("Starting http serving on '%s'", s.addr)
	go func(ctx context.Context) {
		<-ctx.Done()
		_ = httpSrv.Close()
	}(ctx)
	return httpSrv.ListenAndServe()
}
