package render

import (
	pb "a.yandex-team.ru/infra/fwmanager/proto"
	"errors"
)

type DummyFwData struct {
	fqdn    string
	devices []DevFw
	project string
}

type DevFw struct {
	DevType    string
	DevModel   string
	DevVersion string
}

// Just because no repo
var DummyFwRepo = map[string]DummyFwData{"test.search.yandex.net": {fqdn: "test1.search.yandex.net",
	devices: []DevFw{{DevType: "disk", DevModel: "toshibo", DevVersion: "aaa1"}}, project: "rtc"}}
var _ = DummyFwRepo

func GetFwbyFQDN(fqdn string, devices []*pb.Device, project string) (*pb.GetFWVersionsReply, error) {
	var resp []*pb.DeviceReply
	hostinfo, ok := DummyFwRepo[fqdn]
	if !ok {
		// ToDo Fallback?
		return nil, errors.New("host not found in fw repo db")
	}
	for _, t := range devices {
		for _, d := range hostinfo.devices {
			if t.Type == d.DevType && t.Model == d.DevModel {
				resp = append(resp, &pb.DeviceReply{Device: &pb.Device{Type: d.DevType, Model: d.DevModel}, Ok: &pb.Condition{Status: "true", Message: "", TransitionTime: nil}, Version: d.DevVersion})
			}
		}
	}
	return &pb.GetFWVersionsReply{Devices: resp}, nil
}
