# coding: utf8
import uuid

from datetime import datetime


def _get_request_id():
    return int(uuid.uuid4().int & (1 << 32) - 1)


def find_request(mongo_db, request_id):
    print('find: {}'.format({'id': int(request_id)}))
    request = list(mongo_db.gencfg_gui_requests.find({'id': int(request_id)}))
    return request[0] if request else None


def find_requests(mongo_db, query, sort_key='time.added', sort_value=-1, limit=10):
    print('find: {}'.format(query))
    return list(mongo_db.gencfg_gui_requests.find(query).sort(sort_key, sort_value))


def create_request(mongo_db, request_type, essence_info, request_params, login, copied=0):
    date_time = datetime.now()
    request_params.update({'author': login})

    mongo_db.gencfg_gui_requests.insert_one({
        'id': _get_request_id(),
        'type': request_type,
        'author': login,
        'status': 'enqueued',
        'params': request_params,
        'sb_task_id': None,
        'time': {
            'added': date_time,
            'updated': date_time
        },
        'essence': {
            'type': essence_info.get('type'),
            'name': essence_info.get('name')
        },
        'debug': {
            'copied': copied
        }
    })


def remove_request(mongo_db, request_id):
    mongo_db.gencfg_gui_requests.remove({'id': int(request_id)})


def update_request(mongo_db, request_id, changed_data):
    changed_data['time.updated'] = datetime.now()
    mongo_db.gencfg_gui_requests.update({'id': int(request_id)}, {'$set': changed_data})


def save_request(mongo_db, request_type, essence_name, request_params, login):
    if request_type not in {'allocate_in_all_dynamic', 'recluster_in_all_dynamic',
                            'modify_group_card', 'remove_group', 'create_macros', 'remove_macros',
                            'modify_macros', 'manipulate_types', 'manipulate_hosts', 'build_improxy'}:
        return

    essence_type = None
    if request_type in ('allocate_in_all_dynamic', 'recluster_in_all_dynamic', 'modify_group_card', 'remove_group',
                        'manipulate_hosts'):
        essence_type = 'group'
    elif request_type in ('create_macros', 'remove_macros', 'modify_macros'):
        essence_type = 'macro'
    elif request_type in ('manipulate_types',):
        essence_type = 'type'
    elif request_type in ('build_improxy',):
        essence_type = 'config'

    create_request(
        mongo_db=mongo_db,
        request_type=request_type,
        essence_info={'type': essence_type, 'name': essence_name},
        request_params=request_params,
        login=login
    )


def skip_request(mongo_db, request_id):
    update_request(
        mongo_db=mongo_db,
        request_id=request_id,
        changed_data={'status': 'skip'}
    )


def copy_request(mongo_db, request_id, login):
    template_request = find_request(mongo_db, request_id)
    create_request(
        mongo_db=mongo_db,
        request_type=template_request['type'],
        essence_info=template_request['essence'],
        request_params=template_request['params'],
        login=login,
        copied=template_request['id']
    )
