def validate_json_value(field, item, regex=None):
    if regex and not regex(item):
        raise ValueError('{} has invalid format `{}`'.format(
            field, item
        ))


def validate_json_dict(field, dct, scheme):
    for key, item in dct.iteritems():
        if key not in scheme:
            raise ValueError('Unsupported field `{}[{}]`'.format(field, key))

        item_scheme = scheme[key]
        item_type = item_scheme.get('type')

        if not isinstance(item, item_type):
            raise ValueError('{}[{}] has invalid type `{}`, need `{}`'.format(
                field, key, type(item).__name__, item_type.__name__
            ))
        elif item_type == list:
            print(key, item, len(item), scheme.get('length'))
            validate_json_list(
                '{}[{}]'.format(field, key), item, item_scheme.get('items', {}), item_scheme.get('length')
            )
        elif item_type == dict:
            validate_json_dict('{}[{}]'.format(field, key), item, item_scheme.get('scheme', {}))
        elif item_type:
            validate_json_value('{}[{}]'.format(field, key), item, item_scheme.get('regex', {}))


def validate_json_list(field, lst, items, lenght):
    if lenght is not None and len(lst) != lenght:
        raise ValueError('{} has invalid length `{}`, need `{}`'.format(
            field, len(lst), lenght
        ))

    for i, item in enumerate(lst):
        item_type = items.get('type')
        if not isinstance(item, item_type):
            raise ValueError('{}[{}] has invalid type `{}`, need `{}`'.format(
                field, i, type(item).__name__, item_type.__name__
            ))
        elif item_type == list:
            validate_json_list('{}[{}]'.format(field, i), item, items.get('items', {}), items.get('length'))
        elif item_type == dict:
            validate_json_dict('{}[{}]'.format(field, i), item, items.get('scheme', {}))
        elif item_type:
            validate_json_value('{}[{}]'.format(field, i), item, items.get('regex', {}))


def validate(data, scheme):
    data_type = scheme.get('type')
    if not isinstance(data, data_type):
        raise ValueError('{} has invalid type `{}`, need `{}`'.format(
            'root', type(data).__name__, data_type.__name__
        ))
    elif data_type == list:
        validate_json_list('', data, scheme.get('items', {}), scheme.get('length'))
    elif data_type == dict:
        validate_json_dict('', data, scheme.get('scheme', {}))
    else:
        raise ValueError('Unsupported format')
