from collections import namedtuple

import pymongo


MongoStorage = namedtuple('MongoStorage', ['uri', 'replicaset', 'read_preference'])

ALL_HEARTBEAT_C_MONGODB = MongoStorage(
    uri=','.join([
        'myt0-4012.search.yandex.net:27017',
        'myt0-4019.search.yandex.net:27017',
        'sas1-6063.search.yandex.net:27017',
        'sas1-6136.search.yandex.net:27017',
        'vla1-3984.search.yandex.net:27017',
    ]),
    replicaset='heartbeat_mongodb_c',
    read_preference=pymongo.ReadPreference.SECONDARY_PREFERRED
)

mongo_db = pymongo.MongoReplicaSetClient(
    ALL_HEARTBEAT_C_MONGODB.uri,
    replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
    read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
)['ggdb']

db_topology_commits = pymongo.MongoReplicaSetClient(
    ALL_HEARTBEAT_C_MONGODB.uri,
    replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
    read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
)['topology_commits']

db_hosts_data = pymongo.MongoReplicaSetClient(
    ALL_HEARTBEAT_C_MONGODB.uri,
    replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
    read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
)['hosts_data']
