var suggest_by_term = new Bloodhound({
  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('value'),
  queryTokenizer: Bloodhound.tokenizers.whitespace,
  remote: {
    url: '/suggest/%QUERY',
    wildcard: '%QUERY'
  }
});


var suggest_by_tag = new Bloodhound({
  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('value'),
  queryTokenizer: Bloodhound.tokenizers.whitespace,
  remote: {
    url: '/tagsuggest/%QUERY',
    wildcard: '%QUERY'
  }
});


var suggest_by_owner = new Bloodhound({
  datumTokenizer: function(d) {
    console.log(d.value); 
    return Bloodhound.tokenizers.whitespace(d.value); 
  },
  queryTokenizer: Bloodhound.tokenizers.whitespace,
  remote: {
    url: '/ownersuggest/%QUERY',
    wildcard: '%QUERY'
  }
});


$('#scrollable-dropdown-menu .typeahead').typeahead(null, {
  limit: 20,
  name: 'suggest_by_term',
  source: suggest_by_term,
  templates: {
      suggestion: function (data) {
          return "<p><a href=\"/trunk/groups/" + data + "\">" + data + "</a></p>"
      }
  }
});


$('#scrollable-dropdown-menu .tagsuggest').typeahead(null, {
  limit: 20,
  name: 'suggest_by_tag',
  source: suggest_by_tag,
  templates: {
      suggestion: function (data) {
          var parts = data.split('|');
          return '<p>' + parts[0] + '</p>';
      }
  }
});


$('#scrollable-dropdown-menu .ownersuggest').typeahead(null, {
    limit: 20,
    name: 'suggest_by_owner',
    source: suggest_by_owner,
    templates: {
        suggestion: function() {
            var separator = ",";
            var res = function (data) {
                var last_item_suggest = data.split(separator);
                return "<p>" + last_item_suggest[last_item_suggest.length - 1] + "</p>";
            };
            return res;
        }()
  }
});

