import gevent


def raw_group_name(group_name):
    for loc in ('MAN_', 'VLA_', 'SAS_', 'MSK_IVA_', 'MSK_MYT_'):
        if group_name.startswith(loc):
            return group_name.replace(loc, '')
    return group_name


def make_promise(func, *args, **kwargs):
    return gevent.spawn(func, *args, **kwargs)


def wait_promises(*promises, **kwargs):
    for promise in gevent.iwait(promises, timeout=kwargs.get('timeout', 300)):
        promise.get()
    return [promise.get() for promise in promises]
