# coding: utf8
import os
import datetime
import logger as logger


class FileLogger(logger.Logger):
    def __init__(self, name, logs_dir):
        super(FileLogger, self).__init__(name)
        self.logs_dir = logs_dir

    def logging(self, section, text):
        logfile = '{}.log'.format(self.name)
        logfile = os.path.join(self.logs_dir, logfile)
        timestamp = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')

        if not os.path.exists(self.logs_dir):
            os.mkdir(self.logs_dir)

        with open(logfile, 'a') as out:
            out.write('{}\t{}\t{{{}}}\t{}\n'.format(
                section, self.name, timestamp, text
            ))
