# coding: utf8


class Logger(object):
    def __init__(self, name):
        self.name = name

    def debug(self, text):
        self.logging('DEBUG', text)

    def info(self, text):
        self.logging('INFO', text)

    def call(self, func_name, args=None, kwargs=None):
        self.__func_logging('CALL', func_name, args, kwargs)

    def success(self, func_name, args=None, kwargs=None):
        self.__func_logging('SUCCESS', func_name, args, kwargs)

    def failure(self, func_name, args=None, kwargs=None):
        self.__func_logging('FAILURE', func_name, args, kwargs)

    def time(self, func_name, work_time, args=None, kwargs=None):
        self.__func_logging('TIME', func_name, args, kwargs, '{:.3f}'.format(work_time))

    def error(self, text):
        self.logging('ERROR', text)

    def traceback(self, text):
        self.logging('TRACEBACK', '\n{}\n{}'.format(
            text, '-' * 80
        ))

    def __func_logging(self, section, func_name, args=None, kwargs=None, text=''):
        args = [str(x) for x in args] if args else []
        kwargs = ['{}={}'.format(k, v) for k, v in kwargs.iteritems()] if kwargs else []
        self.logging(section, '{}({}, {}) {}'.format(func_name, ','.join(args), ','.join(kwargs), text))

    def logging(self, section, text):
        raise NotImplementedError('This method need implementation')
