# coding: utf8
import sys

import logging_settings

from web import app


def main():
    if len(sys.argv) != 2:
        print('Usage: ./gencfg-monitoring <port>')
        sys.exit(0)

    logging_settings.main_logger.info('Starting gencfg-monitoring at {} port'.format(sys.argv[1]))

    # app = Flask(__name__)
    app.states.update()
    app.states.start()
    app.pusher.start()
    app.monitoring.run(host='::', port=int(sys.argv[1]), use_reloader=False, debug=True)

    logging_settings.main_logger.info('Finished gencfg-monitoring')


if __name__ == '__main__':
    main()
