# coding: utf8
import time
import requests
import traceback

import logger


collector_logger = logger.LoggerWrapper.get_logger('collector')


def retry(tries, delay):
    def decorator(func):
        def wrapper(*args, **kwargs):
            for i in xrange(tries):
                try:
                    return func(*args, **kwargs)
                except Exception as e:
                    if i == tries - 1:
                        collector_logger.traceback(traceback.format_exc(limit=20))
                        raise
                    collector_logger.error('Exception({}): {}: {}'.format(i, type(e), e))
                    time.sleep(delay)
        return wrapper
    return decorator


def make_url(base_url, api_method, **kwargs):
    url = '{}/{}'.format(base_url, api_method)
    for key, value in kwargs.iteritems():
        if '?' in url:
            url = '{}&{}={}'.format(url, key, value)
        else:
            url = '{}?{}={}'.format(url, key, value)
    collector_logger.info('Maked url: {}'.format(url))
    return url


@retry(20, 1)
def http_get(url, data=None):
    data = data or {}

    response = requests.get(url, **data)

    if response.status_code != 200:
        raise RuntimeError('Response code for `{} : {}` == {}'.format(url, data, response.status_code))

    return response.json()
