# coding: utf8
import datetime

import svn
import mongo
import sandbox


def get_first_commit_not_in_tag():
    last_tag_name = mongo.get_last_tag()['tag']
    commits_after_tag = svn.get_commits_after_tag(last_tag_name, 1000)
    return commits_after_tag[-1] if commits_after_tag else None


def get_last_tested_commit():
    last_tested_revision = int(mongo.get_last_tested_commit()['commit'])
    all_last_commits = svn.get_last_merge_commits(100)

    for commit in all_last_commits:
        if last_tested_revision == commit[0]:
            return commit


def get_last_not_tested_commit():
    last_tested_commit = get_last_tested_commit()
    last_db_commits = svn.get_last_db_commits(100)

    if last_tested_commit is None:
        return None

    for commit in reversed(last_db_commits):
        if commit[0] > last_tested_commit[0]:
            return commit


def get_build_tags_delay():
    first_commit_not_in_tag = get_first_commit_not_in_tag()
    time_now = datetime.datetime.utcnow() + datetime.timedelta(hours=+3)  # Europe/Moscow

    if first_commit_not_in_tag is None:
        return 0

    return (time_now - first_commit_not_in_tag[2]).seconds


def get_test_commits_delay():
    first_commit_not_tested = get_last_not_tested_commit()
    time_now = datetime.datetime.utcnow() + datetime.timedelta(hours=+3)  # Europe/Moscow

    if first_commit_not_tested is None:
        return 0

    return (time_now - first_commit_not_tested[2]).seconds


def get_requests_delay(request_type=None):
    return mongo.get_request_delay(request_type)


def get_delay(section):
    if section == 'test':
        return get_test_commits_delay()
    elif section == 'build':
        return get_build_tags_delay()
    elif section == 'requests':
        return get_requests_delay()
    elif section in ('allocate_in_all_dynamic', 'recluster_in_all_dynamic', 'modify_group_card'):
        return get_requests_delay(section)
    return 0


def get_last_task(task_type, wait_release=False):
    finished = (sandbox.GROUP_RELEASED + sandbox.GROUP_ERROR) if wait_release else sandbox.GROUP_FINISHED
    return sandbox.get_last_task(task_type, finished)
