# coding: utf8
import time
import json
import requests
import traceback
import multiprocessing

import logger
import web.states as st

GOLOVAN_HOSTNAME = 'localhost'
GOLOVAN_PUSH_URL = 'http://{}:11005'.format(GOLOVAN_HOSTNAME)
# GOLOVAN_PUSH_URL_PATTERN = 'http://{}.search.yandex.net:11005'

pusher_logger = logger.LoggerWrapper.get_logger('pusher')


def retry(tries, delay):
    def decorator(func):
        def wrapper(*args, **kwargs):
            for i in xrange(tries):
                try:
                    return func(*args, **kwargs)
                except Exception as e:
                    if i == tries - 1:
                        pusher_logger.traceback(traceback.format_exc(limit=20))
                        raise
                    pusher_logger.error('Exception({}): {}: {}'.format(i, type(e), e))
                    time.sleep(delay)
        return wrapper
    return decorator


@retry(5, 1)
def post(url, data, headers):
    requests.post(url, data=data, headers=headers)


def push_to_golovan():
    values_data = []

    for section in st.States.delay_sections:
        trigger_value = st.States.get_delay(section)['value']
        values_data.append({
            'name': 'gencfg-monitoring-{}-delay_attt'.format(section.replace('_', '-')),
            'val': trigger_value
        })

    for section in st.States.state_sections:
        trigger_value = st.States.get_state(section)['value']['ok']
        values_data.append({
            'name': 'gencfg-monitoring-{}-status_attt'.format(section.replace('_', '-').lower()),
            'val': 0 if trigger_value else 2
        })

    push_data = [{
        'tags': {
            'itype': 'gencfg',
            'ctype': 'testing'
        },
        'ttl': 30,
        'values': values_data
    }]

    # for hostname in ('vla1-0556', 'vla1-5970', 'vla1-6019',
    #                  'man2-0275', 'man2-0295', 'man2-0486',
    #                  'sas1-1862', 'sas1-4006', 'sas1-5574'):
    #     post(
    #         GOLOVAN_PUSH_URL_PATTERN.format(hostname),
    #         data=json.dumps(push_data, indent=4),
    #         headers={'Host': '{}.search.yandex.net'.format(hostname)}
    #     )

    post(GOLOVAN_PUSH_URL, data=json.dumps(push_data, indent=4), headers={'Host': GOLOVAN_HOSTNAME})


class GolovanPusher(object):
    def update(self):
        try:
            push_to_golovan()
        except Exception as e:
            print('{}: {}'.format(type(e).__name__, e))

    def _updater(self):
        while True:
            self.update()
            time.sleep(4)

    def start(self):
        p = multiprocessing.Process(target=self._updater)
        p.start()
        return p
