# coding: utf8
import app

from flask import json


@app.monitoring.route('/')
def all_status():
    data = {
        'delays': app.states.get_delay(),
        'states': app.states.get_state()
    }

    return app.monitoring.response_class(
        response=json.dumps(data),
        status=200,
        mimetype='application/json'
    )


@app.monitoring.route('/delay')
@app.monitoring.route('/delay/<section>')
def delay(section=None):
    delay_value = app.states.get_delay(section)
    delay_response = {section: delay_value} if section else delay_value

    return app.monitoring.response_class(
        response=json.dumps(delay_response),
        status=200,
        mimetype='application/json'
    )


@app.monitoring.route('/state')
@app.monitoring.route('/state/<section>')
def status(section=None):
    state_value = app.states.get_state(section)
    state_response = {section: state_value} if section else state_value

    return app.monitoring.response_class(
        response=json.dumps(state_response),
        status=200,
        mimetype='application/json'
    )
