# coding: utf8
import time
import json
import datetime
import traceback
import multiprocessing

import logger
import web.collector as collector

collector_logger = logger.LoggerWrapper.get_logger('collector')


class States(object):
    m = multiprocessing.Manager()
    # For work delay_sections need change web.collector.collector.get_delay
    delay_sections = ('test', 'build', 'requests',
                      'allocate_in_all_dynamic', 'recluster_in_all_dynamic', 'modify_group_card')
    state_sections = ('TEST_CONFIG_GENERATOR_2', 'BUILD_CONFIG_GENERATOR')
    releasing_tasks = ('BUILD_CONFIG_GENERATOR',)

    delay = m.dict({
        section: {'value': 0, 'updated': datetime.datetime(1971, 1, 1)} for section in delay_sections
    })
    delay_lock = {section: multiprocessing.Lock() for section in delay_sections}
    delay_updater = {section: collector.get_delay for section in delay_sections}

    state = m.dict({
        section: {
            'value': {
                'id': 0,
                'ok': True,
                'status': '',
                'updated': datetime.datetime(1971, 1, 1)
            },
            'updated': datetime.datetime(1971, 1, 1)
        }
        for section in state_sections
    })
    state_lock = {section: multiprocessing.Lock() for section in state_sections}
    state_updater = {section: collector.get_last_task for section in state_sections}

    @staticmethod
    def update_delay(section):
        try:
            temp = States.delay_updater[section](section)
        except Exception:
            collector_logger.traceback(traceback.format_exc(limit=20))
            return

        with States.delay_lock[section]:
            States.delay[section] = {
                'value': temp,
                'updated': datetime.datetime.utcnow()
            }

            collector_logger.info('Section delay changed {} -> {}'.format(
                section, temp
            ))

    @staticmethod
    def get_delay(section=None):
        if not section:
            return {section: States.get_delay(section) for section in States.delay_sections}
        with States.delay_lock[section]:
            delay = {
                'value': States.delay[section]['value'],
                'updated': States.delay[section]['updated'].strftime('%Y-%m-%d %H:%M:%S')
            }

            collector_logger.info('Return delay for section {} -> {}'.format(
                section, json.dumps(delay)
            ))

            return delay

    @staticmethod
    def update_state(section):
        wait_release = section in States.releasing_tasks
        try:
            temp = States.state_updater[section](section, wait_release)
        except Exception:
            collector_logger.traceback(traceback.format_exc(limit=20))
            return

        with States.state_lock[section]:
            if temp['info']['id'] < States.state[section]['value']['id']:
                return
            elif temp['info']['id'] == States.state[section]['value']['id'] and \
                    temp['info']['updated'] <= States.state[section]['value']['updated']:
                return
            old_task = States.state[section]['value']

            States.state[section] = {
                'value': {
                    'id': temp['info']['id'],
                    'ok': collector.sandbox.get_status_from_task(temp, wait_release),
                    'status': temp['info']['status'],
                    'updated': temp['info']['updated']
                },
                'updated': datetime.datetime.utcnow()
            }

            collector_logger.info('Task changed {} ({}:{}) -> ({}:{})'.format(
                section, old_task['id'], old_task['status'],
                temp['info']['id'], temp['info']['status']
            ))

    @staticmethod
    def get_state(section=None):
        if not section:
            return {section: States.get_state(section) for section in States.state_sections}
        with States.state_lock[section]:
            state = {
                'value': {
                    'id': States.state[section]['value']['id'],
                    'ok': States.state[section]['value']['ok'],
                    'status': States.state[section]['value']['status'],
                    'updated': States.state[section]['value']['updated'].strftime('%Y-%m-%d %H:%M:%S')
                },
                'updated': States.state[section]['updated'].strftime('%Y-%m-%d %H:%M:%S')
            }

            collector_logger.info('Return state of {} -> {}'.format(
                section, json.dumps(state)
            ))

            return state

    @staticmethod
    def update():
        for section in States.delay_sections:
            States.update_delay(section)
        for section in States.state_sections:
            States.update_state(section)

        collector_logger.info('Updated')

    @staticmethod
    def start():
        p = multiprocessing.Process(target=States._updater)
        p.start()
        return p

    @staticmethod
    def _updater():
        while True:
            States.update()
            time.sleep(5)
