# coding: utf8
import time
import traceback
import multiprocessing

import logger
import tasks
import sdk.scheduler as scheduler


gnb_logger = logger.LoggerWrapper.get_logger('gnb')


class GencfgNotifyBot(object):
    def __init__(self, scheduler_cycle_delay=10):
        self.supported_task_types = tasks.supported_task_types
        self.tasks_queue = [x for x in tasks.test_tasks_queue if x['type'] in self.supported_task_types]
        self.scheduler_cycle_delay = scheduler_cycle_delay

        self.scheduler = scheduler.Scheduler(self.tasks_queue, self.supported_task_types)
        self.__stop = multiprocessing.Value('i', 0)

    def manual_run(self):
        self.scheduler.schedule()

    def start(self):
        try:
            while not self.__stop.value:
                self.scheduler.schedule()
                time.sleep(self.scheduler_cycle_delay)
        finally:
            traceback.print_exc(limit=20)
            self.__stop.value = 0

    def stop(self):
        self.__stop.value = 1
