# coding: utf8
import logger as logger


class CombinedLogger(logger.Logger):
    def __init__(self, name, loggers):
        super(CombinedLogger, self).__init__(name)
        self.loggers = loggers
        for logger_ in self.loggers:
            logger_.name = name

    def logging(self, section, text):
        for logger_ in self.loggers:
            logger_.logging(section, text)
